/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.JythonUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.dom.ApplicationController;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.scriptconsole.DebuggerConsole;
import org.autoplot.scriptconsole.JythonScriptPanel;
import org.das2.components.DasProgressPanel;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.GitCommand;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.FileUtil;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySyntaxError;
import org.python.core.PyTraceback;
import org.python.core.ThreadState;
import org.python.core.parser;
import org.python.parser.ast.Expr;
import org.python.parser.ast.Module;
import org.python.parser.ast.Str;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.stmtType;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class AppScriptPanelSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.jython");
    private static final int RECENT_FILES_COUNT = 100;
    File file;
    final ApplicationModel model;
    final ApplicationController applicationController;
    final DataSetSelector selector;
    final JythonScriptPanel panel;
    final EditorAnnotationsSupport annotationsSupport;
    private final String PREFERENCE_OPEN_FILE = "openFile";
    private InteractiveInterpreter interruptible;
    ThreadState ts;
    WatchService watcher;
    public static final String PROP_INTERRUPTABLE = "interruptable";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    AppScriptPanelSupport(JythonScriptPanel panel, ApplicationModel model, DataSetSelector selector) {
        this.model = model;
        this.applicationController = model.getDocumentModel().getController();
        this.selector = selector;
        this.panel = panel;
        this.annotationsSupport = panel.getEditorPanel().getEditorAnnotationsSupport();
        this.applicationController.addPropertyChangeListener("focusUri", evt -> {
            if (panel.runningScript == null) {
                this.maybeDisplayDataSourceScript();
            }
        });
    }

    private boolean canDisplayDataSourceScript(String sfile) {
        if (sfile == null) {
            return false;
        }
        URISplit split = URISplit.parse((String)sfile);
        if (!URISplit.implicitVapScheme((URISplit)split).endsWith("jyds")) {
            return false;
        }
        if (this.panel.isDirty()) {
            logger.fine("editor is dirty, not showing script.");
            return false;
        }
        if (this.panel.getRunningScript() != null) {
            logger.fine("editor is busy running a script.");
            return false;
        }
        String existingFile = this.panel.getFilename();
        if (existingFile != null) {
            URISplit split2 = URISplit.parse((String)existingFile);
            if (split2.ext.equals(".jy")) {
                return false;
            }
        }
        return true;
    }

    private boolean scriptIsAlreadyShowing(String sfile) {
        try {
            LinkedHashMap params;
            URISplit split = URISplit.parse((String)sfile);
            sfile = split.params != null ? ((params = URISplit.parseParams((String)split.params)).containsKey("script") ? (String)params.get("script") : split.resourceUri.toString()) : split.resourceUri.toString();
            URI fsfile = DataSetURI.getURI((String)sfile);
            if (this.panel.getFilename() != null) {
                File ff1;
                File ff2;
                File ff12;
                URI u1 = DataSetURI.getURI((String)this.panel.getFilename());
                String f1 = URISplit.parse((URI)u1).file;
                URI u2 = DataSetURI.getURI((String)sfile);
                String f2 = URISplit.parse((URI)u2).file;
                if (f1.startsWith("file:") && f2.startsWith("file:") && (ff12 = new File(f1.substring(5))).equals(ff2 = new File(f2.substring(5)))) {
                    return true;
                }
                File ff3 = DataSetURI.getCacheFilename((URI)fsfile);
                if (f1.startsWith("file:") && ff3 != null && ff3.equals(ff1 = new File(f1.substring(5)))) {
                    return true;
                }
            }
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private boolean maybeDisplayDataSourceScript() throws HeadlessException {
        try {
            String sfile = this.applicationController.getFocusUri();
            if (sfile.trim().isEmpty()) {
                return false;
            }
            URISplit split = URISplit.parse((String)sfile);
            LinkedHashMap params = URISplit.parseParams((String)split.params, (boolean)false);
            String script = (String)params.get("script");
            String fsfile = script != null && script.trim().length() > 0 ? script : split.file;
            if (!this.canDisplayDataSourceScript(fsfile)) {
                return false;
            }
            if (this.scriptIsAlreadyShowing(fsfile)) {
                return true;
            }
            Runnable swrun = () -> {
                try {
                    this.panel.getEditorPanel().getEditorKit();
                    SimpleAttributeSet att = new SimpleAttributeSet();
                    StyleConstants.setItalic(att, true);
                    this.file = null;
                    this.panel.getEditorPanel().getDocument().remove(0, this.panel.getEditorPanel().getDocument().getLength());
                    this.panel.getEditorPanel().getDocument().insertString(0, "loading " + fsfile, att);
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                swrun.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(swrun);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            Runnable run = () -> {
                try {
                    this.file = DataSetURI.getFile((String)fsfile, (ProgressMonitor)new NullProgressMonitor());
                    this.loadFile(this.file);
                    this.panel.setContext(1);
                    this.panel.setFilename(this.file.toString());
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            };
            new Thread(run, "load script thread").start();
        }
        catch (NullPointerException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    public int getSaveFile() throws IOException {
        int r;
        String openFile;
        Preferences prefs;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("python and jython scripts", "jy", "py", "jyds"));
        JCheckBox cb = new JCheckBox("rename");
        cb.setEnabled(true);
        cb.setToolTipText("rename file, deleting old name \"" + this.file + "\"");
        chooser.setAccessory(cb);
        if (this.file != null && !FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)this.file)) {
            chooser.setSelectedFile(this.file);
        } else {
            if (FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)this.file)) {
                String home = System.getProperty("user.home");
                File ff = new File(home + File.separator + this.file.getName());
                chooser.setSelectedFile(ff);
            } else {
                chooser.setSelectedFile(this.file);
            }
            prefs = AutoplotSettings.settings().getPreferences(AppScriptPanelSupport.class);
            openFile = prefs.get("openFile", "");
            if (!openFile.equals("") && !FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)new File(openFile))) {
                File dir = new File(openFile).getParentFile();
                chooser.setCurrentDirectory(dir);
            }
        }
        if (this.file == null && !(openFile = (prefs = AutoplotSettings.settings().getPreferences(AppScriptPanelSupport.class)).get("openFile", "")).equals("")) {
            chooser.setCurrentDirectory(new File(openFile).getParentFile());
        }
        if ((r = chooser.showSaveDialog(this.panel)) == 0) {
            File oldFile = this.file;
            this.file = chooser.getSelectedFile();
            if (!(this.file.toString().endsWith(".jy") || this.file.toString().endsWith(".py") || this.file.toString().endsWith(".jyds"))) {
                this.file = this.panel.getContext() == 1 ? new File(this.file.toString() + ".jyds") : new File(this.file.toString() + ".jy");
            }
            if (oldFile != null && cb.isSelected() && !oldFile.equals(this.file) && !oldFile.delete()) {
                JOptionPane.showMessageDialog(this.panel, "unable to delete old file: " + oldFile);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int save() throws FileNotFoundException, IOException {
        if (this.file == null || this.file.toString().contains(FileSystem.settings().getLocalCacheDir().toString())) {
            logger.fine("file is null ");
            if (this.panel.isDirty()) {
                return this.saveAs();
            }
            return 0;
        }
        try (OutputStream out = null;){
            if (!(this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite())) {
                throw new IOException("unable to write to file: " + this.file);
            }
            if (this.watcher != null) {
                try {
                    logger.fine("closing watcher");
                    this.watcher.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            } else {
                logger.fine("logger was null");
            }
            out = new FileOutputStream(this.file);
            String text = this.panel.getEditorPanel().getText();
            out.write(text.getBytes());
            this.panel.setDirty(false);
            File ffile = this.file;
            Runnable run = () -> {
                try {
                    logger.fine("pausing before restarting watcher");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AppScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    logger.fine("restarting watcher");
                    this.restartWatcher(ffile);
                }
                catch (IOException ex) {
                    Logger.getLogger(AppScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
            };
            new Thread(run).start();
        }
        return 0;
    }

    private void watcherRunnable(WatchService watch, Path fpath) {
        Runnable run = () -> {
            Path parent = fpath.getParent();
            logger.log(Level.FINER, "start watch event loop on {0}", new Object[]{parent});
            while (true) {
                try {
                    WatchKey key;
                    block21: do {
                        key = this.watcher.take();
                        Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                        while (iterator.hasNext()) {
                            WatchEvent<?> e;
                            WatchEvent<?> ev = e = iterator.next();
                            Path name = (Path)ev.context();
                            logger.log(Level.FINER, "watch event {0} {1}", new Object[]{ev.kind(), ev.context()});
                            if (!parent.resolve(name).equals(fpath)) continue;
                            try (FileInputStream in = new FileInputStream(this.file);){
                                String newContents = new String(FileUtil.readBytes((InputStream)in));
                                String currentf = this.panel.getEditorPanel().getText();
                                currentf = currentf.trim();
                                newContents = newContents.trim();
                                if (currentf.equals(newContents)) {
                                    logger.fine("timestamp changed but contents are the same.");
                                    continue block21;
                                }
                            }
                            catch (IOException ex) {
                                continue block21;
                            }
                            if (!this.panel.isDirty()) {
                                try {
                                    Color color = this.panel.getBackground();
                                    this.panel.setBackground(ColorUtil.DODGER_BLUE);
                                    Thread.sleep(300L);
                                    this.panel.setBackground(color);
                                    this.loadFile(this.file);
                                }
                                catch (IOException ex) {
                                    this.panel.setDirty(true);
                                }
                                continue;
                            }
                            if (0 == JOptionPane.showConfirmDialog(this.panel, "File changed on disk.  Do you want to reload?", "File Changed on Disk", 2)) {
                                try {
                                    this.loadFile(this.file);
                                }
                                catch (IOException ex) {
                                    logger.log(Level.SEVERE, null, ex);
                                }
                                continue;
                            }
                            this.panel.setDirty(true);
                        }
                    } while (key.reset());
                    logger.log(Level.FINER, "watch key could not be reset: {0}", key);
                    return;
                }
                catch (ClosedWatchServiceException ex) {
                    logger.log(Level.FINER, "watch service was closed: {0}", watch);
                    return;
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        };
        new Thread(run, "fileWatcherRunnable").start();
    }

    private void restartWatcher(File file) throws IOException {
        logger.entering("org.autoplot.scriptconsole", "restartWatcher {0}", file);
        if (this.watcher != null) {
            this.watcher.close();
        }
        this.watcher = FileSystems.getDefault().newWatchService();
        Path fpath = file.toPath();
        Path parent = fpath.getParent();
        if (parent == null) {
            return;
        }
        try {
            parent.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.watcherRunnable(this.watcher, file.toPath());
        }
        catch (ClosedWatchServiceException ex) {
            logger.fine("watch service was closed");
        }
        logger.exiting("org.autoplot.scriptconsole", "restartWatcher {0}", file);
    }

    protected void loadFile(File file) throws IOException, FileNotFoundException {
        try (FileInputStream r = new FileInputStream(file);){
            this.file = file;
            this.panel.setFilename(file.toString());
            this.loadInputStream(r);
            if (file.toString().endsWith(".jyds")) {
                this.panel.setContext(1);
            } else {
                this.panel.setContext(0);
            }
        }
        this.restartWatcher(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInputStream(InputStream in) throws IOException {
        this.panel.containsTabs = false;
        try (BufferedReader r = null;){
            StringBuilder buf = new StringBuilder();
            r = new BufferedReader(new InputStreamReader(in));
            String s = r.readLine();
            int tabWarn = 3;
            int lineNum = 1;
            while (s != null) {
                if (s.contains("\t")) {
                    this.panel.containsTabs = true;
                    if (tabWarn > 0) {
                        logger.log(Level.FINE, "line {0} contains tabs: {1}", new Object[]{lineNum, s});
                        --tabWarn;
                    }
                }
                buf.append(s).append("\n");
                s = r.readLine();
                ++lineNum;
            }
            String fs = buf.toString();
            Runnable run = () -> {
                try {
                    this.annotationsSupport.clearAnnotations();
                    Document d = this.panel.getEditorPanel().getDocument();
                    d.remove(0, d.getLength());
                    d.insertString(0, fs, null);
                    this.panel.setDirty(false);
                    this.panel.resetUndo();
                }
                catch (NullPointerException ex) {
                    try {
                        Document d = this.panel.getEditorPanel().getDocument();
                        d.remove(0, d.getLength());
                        d.insertString(0, fs, null);
                        this.panel.setDirty(false);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    private boolean uriFilesEqual(String surl1, String surl2) throws URISyntaxException {
        int i1 = surl1.indexOf(63);
        if (i1 == -1) {
            i1 = surl1.length();
        }
        URI uri1 = DataSetURI.getURI((String)surl1.substring(0, i1));
        int i2 = surl2.indexOf(63);
        if (i2 == -1) {
            i2 = surl2.length();
        }
        URI uri2 = DataSetURI.getURI((String)surl2.substring(0, i2));
        if (uri1 == null) {
            return false;
        }
        return uri1.equals(uri2);
    }

    public void annotateError(Throwable ex) {
        StackTraceElement[] ses = ex.getStackTrace();
        if (this.file != null) {
            for (StackTraceElement se : ses) {
                if (se == null || se.getFileName() == null || !se.getFileName().endsWith(this.file.getName()) || se.getLineNumber() <= -1) continue;
                int line = se.getLineNumber();
                this.annotationsSupport.annotateLine(line, "error", ex.toString(), null);
            }
        }
    }

    public void annotateError(PyException ex, int offset, PythonInterpreter interp) {
        PyTraceback otraceback = ex.traceback;
        int line = 0;
        int STACK_LIMIT = 7;
        int count = 0;
        if (ex instanceof PySyntaxError) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            int lineno = offset + ((PyInteger)ex.value.__getitem__(1).__getitem__(1)).getValue();
            this.annotationsSupport.annotateLine(lineno, "maybe_error", ex.toString(), interp);
        }
        while (otraceback instanceof PyTraceback && count < 7) {
            PyTraceback traceback = otraceback;
            if (traceback.tb_frame == null) {
                PyObject o = ex.value;
                if (o != null) {
                    logger.info("when does 574 happen?");
                }
                otraceback = traceback.tb_next;
                continue;
            }
            String fn = traceback.tb_frame.f_code.co_filename;
            if (fn != null && (fn.equals("<iostream>") || fn.equals("<string>") && this.file == null || this.file != null && fn.equals(this.file.getName()))) {
                this.annotationsSupport.annotateLine(offset + traceback.tb_lineno, "error", ex.toString(), interp);
                line = traceback.tb_lineno - 1;
                otraceback = traceback.tb_next;
                ++count;
                continue;
            }
            otraceback = traceback.tb_next;
        }
        if (line < 0) {
            logger.log(Level.WARNING, "no trace information available for error {0}", ex.getMessage());
            line = 0;
        }
        int fline = line;
        EditorTextPane textArea = this.panel.getEditorPanel();
        SwingUtilities.invokeLater(() -> AppScriptPanelSupport.lambda$annotateError$7((JEditorPane)textArea, fline));
    }

    protected void executeScript() {
        this.executeScript(0);
    }

    protected void executeScript(boolean trace) {
        this.executeScript(trace ? 2 : 0);
    }

    private void clearAnnotations() {
        this.annotationsSupport.clearAnnotations();
        ArrayList errs = new ArrayList();
        try {
            boolean lintWarning;
            block21: {
                try {
                    if (this.file == null) {
                        String text = this.panel.getEditorPanel().getText();
                        try (LineNumberReader r = new LineNumberReader(new BufferedReader(new StringReader(text)));){
                            lintWarning = org.autoplot.jythonsupport.JythonUtil.pythonLint((LineNumberReader)r, errs);
                            break block21;
                        }
                    }
                    lintWarning = org.autoplot.jythonsupport.JythonUtil.pythonLint((URI)this.file.toURI(), errs);
                }
                catch (NoClassDefFoundError ex) {
                    logger.warning(ex.toString());
                    lintWarning = false;
                }
            }
            if (lintWarning) {
                EditorAnnotationsSupport esa = this.panel.getEditorPanel().getEditorAnnotationsSupport();
                for (String s : errs) {
                    String[] ss = s.split(":", 2);
                    try {
                        String doc = ss[1];
                        doc = doc.replaceAll("<", "&lt;");
                        doc = doc.replaceAll(">", "&gt;");
                        esa.annotateLine(Integer.parseInt(ss[0]), "codeHint", "Variable name is already used before execution: " + doc + "<br>Consider using a different name");
                    }
                    catch (BadLocationException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptImmediately(int mode) throws RuntimeException, Error {
        block88: {
            int offset = 0;
            int lineOffset = 0;
            this.applicationController.setStatus("busy: running application script");
            DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this.panel), (String)"running script");
            try {
                try {
                    if (this.file != null && (this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite()) && this.panel.isDirty()) {
                        this.save();
                    }
                }
                catch (SecurityException securityException) {
                }
                finally {
                    if (this.file != null) {
                        this.applicationController.getApplicationModel().addRecent("script:" + this.file.toURI().toString());
                    }
                }
                InteractiveInterpreter interp = null;
                try {
                    interp = JythonUtil.createInterpreter(true, false, this.model.getDom(), (ProgressMonitor)mon);
                    EditorAnnotationsSupport.setExpressionLookup((EditorAnnotationsSupport.ExpressionLookup)this.annotationsSupport.getForInterp((PythonInterpreter)interp));
                    if (this.file != null) {
                        URISplit split = URISplit.parse((String)this.file.toString());
                        interp.set("PWD", (Object)split.path);
                    }
                    this.setInterruptible(interp);
                    this.ts = Py.getThreadState();
                    boolean dirty0 = this.panel.isDirty();
                    this.clearAnnotations();
                    this.panel.setDirty(dirty0);
                    if ((mode & 2) == 2) {
                        String script = this.panel.getEditorPanel().getText();
                        Module n = (Module)parser.parse((String)script, (String)"exec");
                        String[] sscript = script.split("\n");
                        for (int iline = 0; iline < n.body.length; ++iline) {
                            int i0;
                            Str s;
                            TryExcept te;
                            int l1;
                            long t0 = System.currentTimeMillis();
                            stmtType stmt = n.body[iline];
                            int l0 = stmt.beginLine;
                            int n2 = l1 = iline < n.body.length - 1 ? n.body[iline + 1].beginLine : sscript.length;
                            if (stmt instanceof TryExcept) {
                                te = (TryExcept)stmt;
                                l0 = te.body[0].beginLine - 1;
                            } else if (stmt instanceof Expr) {
                                Expr exp = (Expr)stmt;
                                if (exp.value instanceof Str) {
                                    s = (Str)exp.value;
                                    l0 = s.beginLine;
                                }
                            }
                            if (iline < n.body.length - 1) {
                                if (n.body[iline + 1] instanceof TryExcept) {
                                    te = (TryExcept)n.body[iline + 1];
                                    l1 = te.body[0].beginLine - 1;
                                } else if (n.body[iline + 1] instanceof Expr) {
                                    Expr exp = (Expr)n.body[iline + 1];
                                    if (exp.value instanceof Str) {
                                        s = (Str)exp.value;
                                        l1 = s.beginLine;
                                    }
                                }
                            }
                            for (int i = lineOffset; i < l0 - 1; ++i) {
                                offset = offset + sscript[i].length() + 1;
                            }
                            lineOffset = l1;
                            int i1 = i0 = offset;
                            for (int itn2 = l0 - 1; itn2 < l1 - 1; ++itn2) {
                                i1 = i1 + sscript[itn2].length() + 1;
                            }
                            String s2 = script.substring(i0, i1);
                            this.clearAnnotations();
                            this.annotationsSupport.annotateChars(i0, i1, "programCounter", "pc", (PythonInterpreter)interp);
                            try {
                                this.annotationsSupport.scrollToOffset(i0);
                            }
                            catch (BadLocationException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                            logger.finest("add Netbeans breakpoint here to debug jython code line-by-line without GDB");
                            interp.exec(JythonRefactory.fixImports((String)s2));
                            offset += s2.length();
                            if (!logger.isLoggable(Level.FINE)) continue;
                            long elapsedTime = System.currentTimeMillis() - t0;
                            int i = s2.indexOf("\n");
                            if (s2.length() > i) {
                                if (i > -1) {
                                    s2 = s2.substring(0, i) + "...";
                                }
                            } else {
                                s2 = s2.substring(0, i);
                            }
                            logger.log(Level.FINE, String.format("%4d %.3f %4d # %s", l0, (double)elapsedTime / 1000.0, l1 - l0, s2));
                        }
                        this.clearAnnotations();
                    } else if ((mode & 1) == 1 || (mode & 8) == 8) {
                        JPanel p = new JPanel();
                        p.setLayout(new BorderLayout());
                        HashMap vars = new HashMap();
                        ParametersFormPanel pfp = new ParametersFormPanel();
                        HashMap<String, PyObject> env = new HashMap<String, PyObject>();
                        env.put("dom", interp.get("dom"));
                        env.put("PWD", interp.get("PWD"));
                        ParametersFormPanel.FormData fd = pfp.doVariables(env, this.panel.getEditorPanel().getText(), vars, p);
                        JScrollPane pane = new JScrollPane(p);
                        if (AutoplotUtil.showConfirmDialog2(this.panel, pane, "edit script parameters", 2) == 0) {
                            ParametersFormPanel.resetVariables((ParametersFormPanel.FormData)fd, vars);
                            String parseExcept = null;
                            for (Map.Entry v : vars.entrySet()) {
                                try {
                                    fd.implement((PythonInterpreter)interp, (String)v.getKey(), (String)v.getValue());
                                }
                                catch (ParseException ex) {
                                    parseExcept = (String)v.getKey();
                                }
                            }
                            if (parseExcept != null) {
                                JOptionPane.showMessageDialog(this.panel, "ParseException in parameter " + parseExcept);
                            } else {
                                String code = this.panel.getEditorPanel().getText();
                                if (this.file == null) {
                                    interp.exec(JythonRefactory.fixImports((String)this.panel.getEditorPanel().getText()));
                                } else {
                                    try (ByteArrayInputStream in = new ByteArrayInputStream(code.getBytes());){
                                        interp.execfile(JythonRefactory.fixImports((InputStream)in, (String)this.file.getName()), this.file.getName());
                                    }
                                }
                            }
                        }
                    } else {
                        boolean experiment = System.getProperty("jythonDebugger", "false").equals("true");
                        if (experiment) {
                            DebuggerConsole dc = DebuggerConsole.getInstance(this.panel);
                            dc.setInterp((PythonInterpreter)interp);
                            interp.setOut(this.getOutput(dc));
                            EditorAnnotationsSupport.setExpressionLookup(expr -> dc.setEval(expr));
                        }
                        String code = this.panel.getEditorPanel().getText();
                        if (this.file != null) {
                            char[] cc = code.toCharArray();
                            boolean warning = false;
                            int ioffs = 0;
                            for (char c : cc) {
                                ++ioffs;
                                if (c <= '\u0080') continue;
                                char ic = c;
                                logger.log(Level.INFO, "non-ASCII character ({0}) at character offset {1}", new Object[]{(int)ic, ioffs});
                                warning = true;
                            }
                            if (warning) {
                                System.err.println("code contains data that will not be represented properly!");
                            }
                            if (experiment) {
                                String fixedCode = JythonRefactory.fixImports((String)code);
                                if (fixedCode.equals(code)) {
                                    interp.execfile(this.file.getAbsolutePath());
                                } else {
                                    File tempFile = new File(this.file.getAbsolutePath() + ".t");
                                    Files.copy(new ByteArrayInputStream(fixedCode.getBytes()), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    interp.execfile(tempFile.getAbsolutePath());
                                }
                            } else {
                                try (ByteArrayInputStream in = new ByteArrayInputStream(code.getBytes());){
                                    interp.execfile(JythonRefactory.fixImports((InputStream)in, (String)this.file.getName()), this.file.getName());
                                }
                            }
                        } else {
                            interp.exec(JythonRefactory.fixImports((String)code));
                        }
                    }
                    this.setInterruptible(null);
                    if (!mon.isFinished()) {
                        mon.finished();
                    }
                    if (this.applicationController.getStatusAgeMillis() > 100L) {
                        this.applicationController.setStatus("done executing script");
                        break block88;
                    }
                    this.applicationController.setStatus(this.applicationController.getStatus() + " (done executing script)");
                }
                catch (IOException ex) {
                    if (!mon.isFinished()) {
                        mon.finished();
                    }
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    this.applicationController.setStatus("error: I/O exception: " + ex.toString());
                }
                catch (PyException ex) {
                    if (!mon.isFinished()) {
                        mon.finished();
                    }
                    this.annotateError(ex, offset, (PythonInterpreter)interp);
                    this.applicationController.setStatus("error: " + ex.toString());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (Error ex) {
                if (ex.getMessage() != null && !ex.getMessage().contains("Python interrupt")) {
                    throw ex;
                }
                this.applicationController.setStatus("script interrupted");
            }
            finally {
                if (!mon.isFinished()) {
                    mon.finished();
                }
                this.setInterruptible(null);
                this.panel.setRunningScript(null);
            }
        }
    }

    protected void executeScript(int mode) {
        block20: {
            try {
                if (this.panel.getContext() == 1) {
                    if (this.file != null) {
                        try {
                            URI uri = new URI("vap+jyds:" + this.file.toURI().toString());
                            JythonDataSourceFactory factory = (JythonDataSourceFactory)DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
                            if (factory != null) {
                                factory.addExeceptionListener(e -> {
                                    if (e instanceof PyException) {
                                        PyException ex = (PyException)((Object)((Object)e));
                                        this.annotateError(ex, 0, null);
                                    }
                                });
                            }
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    boolean updateSurl = false;
                    if (this.file == null || this.panel.isDirty() && FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)this.file)) {
                        if (this.getSaveFile() == 0) {
                            updateSurl = true;
                        } else {
                            return;
                        }
                    }
                    if (this.file != null) {
                        try {
                            if (!this.uriFilesEqual(this.selector.getValue(), this.file.toURI().toString())) {
                                updateSurl = true;
                            }
                        }
                        catch (URISyntaxException ex) {
                            updateSurl = true;
                        }
                        if (this.panel.isDirty() && (this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite())) {
                            this.save();
                        }
                        if (updateSurl) {
                            this.selector.setValue("vap+jyds:" + this.file.toURI().toString());
                        }
                        this.clearAnnotations();
                        if ((mode & 8) == 8 || (mode & 1) == 1) {
                            this.selector.maybePlot(8);
                        } else {
                            this.selector.maybePlot(false);
                        }
                        if (updateSurl) {
                            this.panel.setFilename(this.file.toString());
                        }
                    }
                    this.panel.setRunningScript(null);
                    break block20;
                }
                if (this.panel.getContext() == 0) {
                    Runnable run = () -> this.executeScriptImmediately(mode);
                    new Thread(run, "sessionRunScriptThread").start();
                }
            }
            catch (IOException iOException) {
                this.model.getExceptionHandler().handle((Throwable)iOException);
                this.panel.setRunningScript(null);
            }
        }
    }

    private OutputStream getOutput(DebuggerConsole dc) {
        return new MyOutputStream(System.out, dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int saveAs() {
        int result;
        block17: {
            OutputStream out = null;
            result = 1;
            try {
                result = this.getSaveFile();
                if (result != 0) break block17;
                if (this.watcher != null) {
                    try {
                        this.watcher.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                out = new FileOutputStream(this.file);
                String text = this.panel.getEditorPanel().getText();
                out.write(text.getBytes());
                this.panel.setDirty(false);
                this.panel.setFilename(this.file.toString());
                this.restartWatcher(this.file);
                Preferences prefs = AutoplotSettings.settings().getPreferences(AppScriptPanelSupport.class);
                prefs.put("openFile", this.file.toString());
                if (this.file.toString().endsWith(".jyds")) {
                    this.panel.setContext(1);
                } else {
                    this.panel.setContext(0);
                }
                this.model.addRecent(this.file.toString());
            }
            catch (IOException iOException) {
                this.model.getExceptionHandler().handle((Throwable)iOException);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return result;
    }

    protected void newScript() {
        if (this.panel.isDirty()) {
            int result = AutoplotUtil.showConfirmDialog(this.panel, "save edits first?", "new script", 1);
            if (result == 2) {
                return;
            }
            if (result == 0 && this.saveAs() == 2) {
                return;
            }
        }
        if (this.file != null && this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        try {
            Document d = this.panel.getEditorPanel().getDocument();
            d.remove(0, d.getLength());
            this.panel.containsTabs = false;
            this.panel.setDirty(false);
            this.panel.setFilename(null);
            this.annotationsSupport.clearAnnotations();
            this.file = null;
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private JComponent getRecentAccessory(String filter, int limit, JFileChooser c) {
        JPanel recentPanel = new JPanel(new BorderLayout());
        String msgWait = "Getting Recent...                    ..";
        DefaultListModel<String> waitModel = new DefaultListModel<String>();
        waitModel.add(0, "Getting Recent...                    ..");
        JList p = new JList(waitModel);
        p.setFont(p.getFont().deriveFont(10.0f));
        Runnable run = () -> {
            Map<String, String> recent = this.model.getRecent(filter, 10 * limit);
            DefaultListModel<String> mm = new DefaultListModel<String>();
            ArrayList<String> ss = new ArrayList<String>(recent.keySet());
            int count = 0;
            for (int i = ss.size() - 1; i >= 0; --i) {
                int iq;
                int iscript;
                String s = (String)ss.get(i);
                if (s.startsWith("script:")) {
                    s = s.substring(7);
                }
                if (s.startsWith("vap+jyds:")) {
                    s = s.substring(9);
                }
                if (s.startsWith("vap+jy:")) {
                    s = s.substring(7);
                }
                if ((iscript = s.indexOf("script=")) > -1) {
                    s = s.substring(iscript + "script=".length());
                }
                if (!s.startsWith("file:")) continue;
                if (s.startsWith("file://")) {
                    s = s.substring(7);
                }
                if (s.startsWith("file:")) {
                    s = s.substring(5);
                }
                if ((iq = s.indexOf(63)) > -1) {
                    s = s.substring(0, iq);
                }
                if (mm.contains(s)) continue;
                mm.addElement(s);
                if (++count == limit) break;
            }
            Runnable run1 = () -> p.setModel(mm);
            SwingUtilities.invokeLater(run1);
        };
        new Thread(run).start();
        p.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !p.getSelectedValue().equals("Getting Recent...                    ..")) {
                String s = (String)p.getSelectedValue();
                File ff = new File(s);
                c.setSelectedFile(ff);
            }
        });
        JScrollPane scrollPane = new JScrollPane(p);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        scrollPane.setMinimumSize(new Dimension(300, 100));
        scrollPane.setMaximumSize(new Dimension(300, 200));
        recentPanel.add((Component)new JLabel("Recently used local (" + filter + ") files:"), "North");
        recentPanel.add((Component)scrollPane, "Center");
        return recentPanel;
    }

    public static int markChanges(EditorAnnotationsSupport support, File fln) throws IOException, InterruptedException {
        GitCommand.GitResponse diffOutput = new GitCommand(fln.getParentFile()).diff(fln);
        if (diffOutput.getExitCode() != 0) {
            JOptionPane.showMessageDialog(null, diffOutput.getErrorResponse());
            return 0;
        }
        Patch deltas = UnifiedDiffUtils.parseUnifiedDiff(Arrays.asList(diffOutput.getResponse().split("\n")));
        support.clearAnnotations();
        List dd = deltas.getDeltas();
        dd.forEach(d -> {
            block4: {
                String sourceText;
                List ss;
                block5: {
                    List ll;
                    block3: {
                        Chunk source = d.getSource();
                        ll = source.getChangePosition();
                        ss = d.getTarget().getChangePosition();
                        sourceText = String.join((CharSequence)"\n", d.getSource().getLines());
                        if (!(d instanceof ChangeDelta)) break block3;
                        Iterator iterator = ss.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            int[] lp0 = support.getLinePosition(i);
                            int[] lp1 = support.getLinePosition(i);
                            System.err.println(String.format("change characters %d through %d", lp0[0], lp1[1]));
                            support.annotateChars(lp0[0], lp1[1], "change", sourceText, null);
                        }
                        break block4;
                    }
                    if (!(d instanceof DeleteDelta)) break block5;
                    Iterator iterator = ll.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        int[] lp0 = support.getLinePosition(i);
                        int[] lp1 = support.getLinePosition(i);
                        support.annotateChars(lp0[0], lp1[1], "delete", sourceText, null);
                    }
                    break block4;
                }
                if (!(d instanceof InsertDelta)) break block4;
                Iterator iterator = ss.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    int[] lp0 = support.getLinePosition(i);
                    int[] lp1 = support.getLinePosition(i);
                    System.err.println(String.format("insert characters %d through %d", lp0[0], lp1[1]));
                    support.annotateChars(lp0[0], lp1[1], "insert", sourceText, null);
                }
            }
        });
        return dd.size();
    }

    protected void open() {
        try {
            if (this.file == null) {
                String sfile = this.selector.getValue();
                URISplit split = null;
                if (sfile != null) {
                    split = URISplit.parse((String)sfile);
                }
                if (split == null || split.file == null || !split.file.endsWith(".py") && !split.file.endsWith(".jy")) {
                    this.file = null;
                } else {
                    try {
                        this.file = DataSetURI.getFile((URL)DataSetURI.getURL((String)sfile), (ProgressMonitor)new NullProgressMonitor());
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        logger.fine("old file reference from data set selector is ignored");
                        this.file = null;
                    }
                }
            }
            Preferences prefs = AutoplotSettings.settings().getPreferences(AppScriptPanelSupport.class);
            String openFile = prefs.get("openFile", "");
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileNameExtensionFilter("python and jython scripts", "jy", "py", "jyds"));
            if (this.file != null) {
                chooser.setSelectedFile(this.file);
            }
            if (openFile.length() > 0) {
                chooser.getFileSystemView().isParent(chooser.getCurrentDirectory(), new File(openFile));
                File fopenFile = new File(openFile);
                chooser.setSelectedFile(fopenFile);
            }
            chooser.setAccessory(this.getRecentAccessory("*.jy*", 100, chooser));
            chooser.revalidate();
            int r = chooser.showOpenDialog(this.panel);
            if (r == 0) {
                if (this.panel.isDirty()) {
                    int option = JOptionPane.showConfirmDialog(this.panel, "Save edits first?", "Save Current Editor", 1);
                    if (option == 0) {
                        this.saveAs();
                    } else if (option == 2) {
                        return;
                    }
                }
                this.file = chooser.getSelectedFile();
                prefs.put("openFile", this.file.toString());
                this.loadFile(this.file);
                this.panel.setFilename(this.file.toString());
                this.annotationsSupport.clearAnnotations();
            }
        }
        catch (IOException ex) {
            this.model.getExceptionHandler().handle((Throwable)ex);
        }
    }

    void interrupt() {
        InteractiveInterpreter interp = this.getInterruptible();
        if (interp != null) {
            interp.interrupt(this.ts);
        }
    }

    public InteractiveInterpreter getInterruptible() {
        return this.interruptible;
    }

    private void setInterruptible(InteractiveInterpreter interruptable) {
        InteractiveInterpreter old = this.interruptible;
        this.interruptible = interruptable;
        this.propertyChangeSupport.firePropertyChange(PROP_INTERRUPTABLE, old, interruptable);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(name, listener);
    }

    private static /* synthetic */ void lambda$annotateError$7(JEditorPane textArea, int fline) {
        Element element = textArea.getDocument().getDefaultRootElement().getElement(Math.max(0, fline - 5));
        if (element != null) {
            textArea.setCaretPosition(element.getStartOffset());
        }
        SwingUtilities.invokeLater(() -> {
            Element element1 = textArea.getDocument().getDefaultRootElement().getElement(fline);
            if (element1 != null) {
                textArea.setCaretPosition(element1.getStartOffset());
            }
        });
    }

    protected class MyOutputStream
    extends FilterOutputStream {
        OutputStream sink;
        DebuggerConsole dc;
        StringBuilder currentLine;
        boolean returnFlag;
        private final Object STATE_OPEN;
        private final Object STATE_FORM_PDB_PROMPT;
        private final Object STATE_RETURN_INIT_PROMPT;
        private final Object STATE_PDB;
        protected final Object STATE_FORM_PDB_RESPONSE;
        Object state;

        public MyOutputStream(OutputStream out, DebuggerConsole dc) {
            super(out);
            this.currentLine = new StringBuilder();
            this.returnFlag = false;
            this.STATE_OPEN = "OPEN";
            this.STATE_FORM_PDB_PROMPT = "PROMPT";
            this.STATE_RETURN_INIT_PROMPT = "RETURN";
            this.STATE_PDB = "PDB";
            this.STATE_FORM_PDB_RESPONSE = "RESPONSE";
            this.state = this.STATE_OPEN;
            this.sink = out;
            this.dc = dc;
        }

        public boolean getReturnFlag() {
            return this.returnFlag;
        }

        public void checkState(int b) throws IOException {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AppScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.dc != null) {
                this.dc.print(String.valueOf((char)b), this.state);
            }
            if (this.state == this.STATE_OPEN) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals("(")) {
                    this.state = this.STATE_FORM_PDB_PROMPT;
                } else if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals(">")) {
                    this.state = this.STATE_FORM_PDB_RESPONSE;
                } else if (this.currentLine.length() > 10 && this.currentLine.substring(0, 10).equals("--Return--")) {
                    this.state = this.STATE_RETURN_INIT_PROMPT;
                    this.dc.started();
                    this.dc.next();
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_RETURN_INIT_PROMPT) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals("(")) {
                    this.state = this.STATE_FORM_PDB_PROMPT;
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_FORM_PDB_PROMPT) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() >= 5) {
                    if (this.currentLine.substring(0, 5).equals("(Pdb)")) {
                        this.state = this.STATE_PDB;
                        this.dc.started();
                    } else {
                        this.sink.write(this.currentLine.toString().getBytes());
                        this.state = this.STATE_OPEN;
                    }
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.sink.write(this.currentLine.toString().getBytes());
                    this.currentLine = new StringBuilder();
                    this.state = this.STATE_OPEN;
                }
            } else if (this.state == this.STATE_FORM_PDB_RESPONSE) {
                Pattern p;
                Matcher m;
                if (b >= 0 && b != 10 && b != 13) {
                    this.currentLine.append((char)b);
                }
                if ((m = (p = Pattern.compile("\\>? \\S+\\((\\d+)\\)\\S+\\(\\)")).matcher(this.currentLine)).matches()) {
                    String linenum = m.group(1);
                    AppScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                    int[] pos = AppScriptPanelSupport.this.annotationsSupport.getLinePosition(Integer.parseInt(linenum));
                    AppScriptPanelSupport.this.annotationsSupport.annotateChars(pos[0], pos[1], "programCounter", "pc", (PythonInterpreter)AppScriptPanelSupport.this.interruptible);
                    this.state = this.STATE_OPEN;
                    this.currentLine = new StringBuilder();
                } else if (b == 13 || b == 10) {
                    this.state = this.STATE_OPEN;
                    this.sink.write(this.currentLine.toString().getBytes());
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_PDB) {
                Pattern p = Pattern.compile("\\(Pdb\\) (.*)> .*\\.jy\\((\\d+)\\).*\\(\\)\\s*");
                Pattern p2 = Pattern.compile("\\(Pdb\\) (.*)--Return--.*");
                int l = this.currentLine.length();
                if (b >= 0 && b != 10 && b != 13) {
                    this.currentLine.append((char)b);
                }
                if (l > 2 && this.currentLine.substring(l - 2, l).equals("()")) {
                    Matcher m = p.matcher(this.currentLine);
                    if (m.matches()) {
                        String linenum = m.group(2);
                        AppScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                        int[] pos = AppScriptPanelSupport.this.annotationsSupport.getLinePosition(Integer.parseInt(linenum));
                        AppScriptPanelSupport.this.annotationsSupport.annotateChars(pos[0], pos[1], "programCounter", "pc", (PythonInterpreter)AppScriptPanelSupport.this.interruptible);
                        String userOutput = m.group(1);
                        if (userOutput != null && userOutput.length() > 0) {
                            this.sink.write(userOutput.getBytes());
                            this.sink.write("\n".getBytes());
                        }
                        this.state = this.STATE_OPEN;
                        this.currentLine = new StringBuilder();
                    } else {
                        Matcher m2 = p2.matcher(this.currentLine);
                        if (m2.matches()) {
                            AppScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                            String userOutput = m2.group(1);
                            if (userOutput.length() > 0) {
                                this.sink.write(userOutput.getBytes());
                                this.sink.write("\n".getBytes());
                            }
                            this.state = this.STATE_OPEN;
                            this.currentLine = new StringBuilder();
                            this.dc.finished();
                            this.returnFlag = true;
                            this.dc.next();
                        } else {
                            this.state = this.STATE_OPEN;
                            this.currentLine = new StringBuilder();
                        }
                    }
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.checkState(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            for (int i = 0; i < b.length; ++i) {
                this.write(b[i]);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        }
    }
}

